/*
 * @(#)ZipMainPanel.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import java.util.Vector;
import java.util.Enumeration;

import java.io.File;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Dimension;
import java.awt.Color;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.ScrollPaneConstants;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.BorderFactory;



/**
 * This class construct the main frame of the visual interface.
 * It gives the link between the graphic interface, and the file
 * Archive.
 *
 * @see ZipToolsBar
 * @see Zip
 * @see AllActionListener
 * @see ZipTable
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class ZipMainPanel extends JPanel {

    // private members
    private ZipTable zipTable;
    private Vector data;
    private Vector name;
    private JScrollPane scrollPane;
    private ZipToolsBar toolsBar;
    private Zip zipAccess;
    private AllActionListener allActionListener;
    private JLabel nbFiles;

    /**
     * Constructor of the class
     * @param allActionListener accessor to the general action dispatcher
     * @param zipAccess accessor to the zipArchive, use for the popup menu
     */
    public ZipMainPanel(AllActionListener allActionListener, Zip zipAccess) {

	this.zipAccess = zipAccess;
	this.allActionListener = allActionListener;

	// setup the main panel
	// put it in the current panel
	setLayout(new BorderLayout());

	// creation of the tools bar
	// put it in the current panel
	toolsBar = new ZipToolsBar(allActionListener);
	add("North",toolsBar);

	// creation of the status bar
	// put it in the current panel
	nbFiles = new JLabel("No Archive opened                            ",JLabel.LEFT);
	JPanel statusBar = new JPanel();
	statusBar.setLayout(new FlowLayout(FlowLayout.LEFT));
	statusBar.add(nbFiles);
	add("South",statusBar);
	    
	// creation of titles of the ZipTable columns
	name = new Vector();
	name.addElement("Name");
	name.addElement("Type");
	name.addElement("Modified");
	name.addElement("Size");
	name.addElement("Ratio");
	name.addElement("Packed");
	name.addElement("Path");

	// creation of the data table, empty when start
	data = new Vector();
	
	// creation of the zipTable
	zipTable = new ZipTable(data,name);
	zipTable.addMouseListener(new MouseListener());
	
	// put the zipTable into a scrollpane, to use scroll bars.
	// put the scrollpane into current panel
	scrollPane = new JScrollPane(zipTable);
	scrollPane.setBackground(Color.white);
	scrollPane.setAutoscrolls(true);
	add("Center",scrollPane);
    }


    /**
     * This method is use to activate an desactivate the Edition and Action buttons
     * @param flag true if you want to enable it
     */
    public void enabledToolsAction(boolean flag) {

	toolsBar.setEnabledButtons(flag);
    }


    /**
     * This methods return the selected files in the zipTable
     * @return a Vector of rows, the rows are Vector
     */
    public Vector getSelectedFiles() {
	Vector result = new Vector();
	if(zipTable.getSelectedRowCount() != 0) {
	    int[] selectedRows = zipTable.getSelectedRows();
	    for(int i = 0; i < selectedRows.length; i++) {
		Vector tmp = (Vector) data.elementAt(selectedRows[i]);
		String separator = ((String)tmp.elementAt(6)).length() == 0 ? "" : "/";
		result.addElement((String)tmp.elementAt(6) + separator + (String)tmp.elementAt(0));
	    }
	    return result;
	}
	else {
	    return result;
	}
    }


    /**
     * This Method change the content of the table attached at zipTable
     * and activate the refresh of the zipTable, and the status bar
     * @param newVector the new vector 
     */
    public void changeVectorOfDataVector(Vector newVector) {

	// delete all data in the table
	data.removeAllElements();
	Enumeration enum = newVector.elements();
	while(enum.hasMoreElements()) {
	    data.addElement(enum.nextElement());
	}

	// activate the zipTable refresh
	TableModelEvent tme = new TableModelEvent(zipTable.getModel());
	zipTable.tableChanged(tme);
	zipTable.clearSelection();

	// change the content of the status bar
	int fileNumber = data.size();
	if(!zipAccess.isFileSelected()) {
	    nbFiles.setText("No Archive opened");
	} else if(fileNumber == 0) {
	    nbFiles.setText("No Files into archive");
	} else if(fileNumber == 1) {
	    nbFiles.setText("1 File into archive");
	} else {
	    nbFiles.setText(fileNumber + " Files into archive");
	}	    
    }


    /**
     * This method select all rows in the zipTable
     */
    public void selectAll() {
	
	zipTable.setRowSelectionInterval(0,data.size()-1);
    }


    /**
     * This method deselect rows in the zipTable
     */
    public void selectNone() {
	zipTable.clearSelection();
    }


    /**
     * This internal class is use to have mouse action :
     *  right click to display a popup menu
     *  left bouble click to extrtact the selected entry
     * @see ZipTable
     */
    private class MouseListener extends MouseAdapter {

	/**
	 * This method is redifined to perform the mouse click action
	 * @param e the mouse event
	 */
	public void mouseClicked(MouseEvent e) {

	    // if archive file is opened 
	    if(zipAccess.isFileSelected()) {

		// if right button is clicked
		if(SwingUtilities.isRightMouseButton(e)) {

		    // creation of the popup menu
		    JPopupMenu popupMenu = new JPopupMenu();
		    JMenuItem extractItem = new JMenuItem("Extract");
		    extractItem.setActionCommand("Extract");
		    extractItem.addActionListener(allActionListener);
		    JMenuItem deleteItem = new JMenuItem("Delete");
		    deleteItem.setActionCommand("Delete");
		    deleteItem.addActionListener(allActionListener);
		    JMenuItem extractAllItem = new JMenuItem("Extract All");
		    extractAllItem.setActionCommand("ExtractAll");
		    extractAllItem.addActionListener(allActionListener);

		    // add all items into the popup menu
		    popupMenu.add(extractItem);
		    popupMenu.add(deleteItem);
		    popupMenu.addSeparator();
		    popupMenu.add(extractAllItem);
		    
		    // convert the mouse position, and display the popup menu
		    MouseEvent newE = SwingUtilities.convertMouseEvent(zipTable,e,zipAccess);
		    popupMenu.show(zipAccess,newE.getX(),newE.getY());
		}
		
		// if left double click
		else if ((e.getClickCount() == 2)&&(SwingUtilities.isLeftMouseButton(e))) {
		    zipAccess.extractSelectedFiles();
		}
	    }
	}
    }
}

